/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging;

import eu.gemss.components.transport.*;
import eu.gemss.components.transport.payload.*;
import java.io.*;

/**
 * InvocationInputImp provides default implementation of InvocationInput interface
 */
public class InvocationInputImp implements InvocationInput {

    private Payload mPayload;

    public InvocationInputImp(Payload p) {
        mPayload = p;
    }

    /**
     * Retrieves the payload that contains the data items
     * @return payload container
     */
    public Payload getPayload() {
        return mPayload;
    }

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        out.writeObject(mPayload);
    }
    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        mPayload = (Payload) in.readObject();
    }
}
