/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging;

import eu.gemss.components.transport.*;
import eu.gemss.components.transport.payload.*;
import java.io.*;

/**
 * InvocationOutputImp provides a default implementation of the InvocationOutput interface
 */
public class InvocationOutputImp implements InvocationOutput {

    private Payload mPayload;
    private boolean mSuccess;
    private String mReportString;

    public InvocationOutputImp(Payload outPayload,boolean success,String reportString) {
        mPayload = outPayload;
        mSuccess = success;
        mReportString = reportString;
    }

    /**
     * Retrieves the payload that includes the output data items
     * @return output payload
     */
    public Payload getPayload() {
        return mPayload;
    }

    /**
     * Tests if the invocation was successful
     * @return true if successful, false otherwise
     */
    public boolean isCorrect() {
        return mSuccess;
    }

    /**
     * Retrieves the report string for the invocation, this will include any
     * error messages if the invocation was unsuccessful
     * @return
     */
    public String getReportString() {
        return mReportString;
    }

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        out.writeObject(mPayload);
        out.writeBoolean(mSuccess);
        out.writeObject(mReportString);
    }
    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        mPayload = (Payload) in.readObject();
        mSuccess = in.readBoolean();
        mReportString = (String) in.readObject();
    }
}
