/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging;

import eu.gemss.components.transport.servicedescription.ServiceDescription;
import eu.gemss.components.transport.payload.Payload;

import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.Message;

/**
 * Service class is a holder for information associated with a single invocation
 *
 */
public class Service {

    private ServiceDescription mServiceDesc;
    private Payload mInputPayload;
    private Payload mOutputPayload;
    private Message mInMessage;
    private Message mOutMessage;

    /**
     * Only constructor initialises takes in enough to do an invocation
     * @param servDesc service description
     * @param inPayload input data
     */
    public Service(ServiceDescription servDesc, Payload inPayload) {
        mServiceDesc = servDesc;
        mInputPayload = inPayload;
    }

    /**
     * Retrieves the service description for the service to invoke
     * @return service description
     */
    public ServiceDescription getServiceDescription() {
        return mServiceDesc;
    }

    /**
     * Retrieves the input payload
     * @return input data
     */
    public Payload getInputPayload() {
        return mInputPayload;
    }

    /**
     * Retrieves the output payload
     * @return output data
     */
    public Payload getOutputPayload() {
        return mOutputPayload;
    }

    /**
     * Retrieves the input message
     * @return input message
     */
    public Message getInMessage() {
        return mInMessage;
    }

    /**
     * Retrieves the output message
     * @return output message
     */
    public Message getOutMessage() {
        return mOutMessage;
    }
}