/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging;

public class TransportMessagingException extends java.lang.Exception {

    private String mUserMessage = null;
    private String mSystemMessage = null;
    private boolean mFatal = true;

    /**
     * Default constructor takes the informative message to send to user and system logs, assumed error is not fatal
     * @param message message to send to user
     */
    public TransportMessagingException(String message) {
        super(message);
        mUserMessage = message;
        mSystemMessage = message;
    }

    /**
     * Default constructor takes the informative message to send to user and system logs, assumed error is not fatal
     * @param message message to send to user
     * @param fatal signals whether error can be recovered from
     */
    public TransportMessagingException(String message, boolean fatal) {
        super(message);
        mUserMessage = message;
        mSystemMessage = message;
        mFatal = fatal;
    }

    /**
     * Constructor enables different messages to be set for user and system logs, assumed that error is not fatal
     * @param userMsg message appropriate for presentation to user
     * @param systemMsg more detailed message suitable for logging
     */
    public TransportMessagingException(String userMsg, String systemMsg) {
        super(userMsg);
        mUserMessage = userMsg;
        mSystemMessage = systemMsg;
    }

    /**
     * Constructor enables different messages to be set for user and system logs and can make the error fatal
     * @param userMsg
     * @param systemMsg
     * @param fatal
     */
    public TransportMessagingException(String userMsg, String systemMsg, boolean fatal) {
        super(userMsg);
        mUserMessage = userMsg;
        mSystemMessage = systemMsg;
        mFatal = fatal;
    }

    /**
     * Retrieve a message appropriate for display to user
     * @return
     */
    public String getUserMessage() {
        return mUserMessage;
    }

    /**
     * Retrieve a more detailed message appropriate for logging.
     * @return
     */
    public String getSystemMessage() {
        return mSystemMessage;
    }

    /**
     * Check to see if it is worth trying again
     * @return true if not worth trying again until resolve problem, false otherwise
     */
    public boolean isFatal() {
        return mFatal;
    }

}
