/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.connection;

import java.io.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.*;

/**
 * Connection represents a connection to some resource, the most common implementation
 * is for remote resources but local resources can accessed through suitable implementations
 */
public interface Connection {

    /**
     * Send the supplied data within the input stream to the connection endpoint associated with
     * the concrete instance
     * @param in inputstream data source
     * @param packetLength size of the data source
     * @param properties name value pairs useful for the connection
     * @return response from the server
     * @throws ConnectionException
     */
    public ConnectionResponse send(Message message) throws ConnectionException;

    /**
     * Retrieve the inputstream for the resource pointed to by this connection
     * @return inputstream to resource
     * @throws ConnectionException
     */
    public InputStream getResourceInputStream() throws ConnectionException;

    /**
     * Release the connection and any associated resources.
     */
    public void releaseConnection();
}

