/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.connection;

import uk.ac.soton.itinnovation.gemss.transportmessaging.*;

public class ConnectionException extends TransportMessagingException {

    private static boolean FATAL_LEVEL = true;
    private int mErrorCode = -1;

    /**
     * Constructor creates a connection exception with a single message for
     * both user and system logging. A default error code of -1 is used. It is assumed not fatal.
     * @param message
     */
    public ConnectionException(String message) {
        super(message,FATAL_LEVEL);
    }

    /**
     * Constructor creates a connection exception with a single message for
     * both user and system logging. A default error code of -1 is used. It is assumed not fatal.
     * @param message
     * @param
     */
    public ConnectionException(String message, boolean fatal) {
        super(message,fatal);
    }

    /**
     * Constructor creates a connection exception with distinct messages for
     * user and system logging. A default error code of -1 is used. It is assumed not fatal.
     * @param userMessage
     * @param systemMessage
     */
    public ConnectionException(String userMessage, String systemMessage) {
        super(userMessage,systemMessage,FATAL_LEVEL);
    }

    /**
     * Constructor creates a connection exception with distinct messages for user
     * and system logging and also sets the error code
     * @param userMessage
     * @param systemMessage
     * @param errorcode
     * @param fatal true if fatal, false otherwise
     */
    public ConnectionException(String userMessage, String systemMessage, int errorcode, boolean fatal) {
        super(userMessage,systemMessage,fatal);
        mErrorCode = errorcode;
    }

    /**
     * Constructor creates a connection exception with distinct messages for user
     * and system logging and also sets the error code
     * @param userMessage
     * @param systemMessage
     * @param fatal true if fatal, false otherwise
     */
    public ConnectionException(String userMessage, String systemMessage, boolean fatal) {
        super(userMessage,systemMessage,fatal);

    }

    /**
     * Retrieve the error code for the connection
     * @return error code
     */
    public int getErrorCode() {
        return mErrorCode;
    }

}
