/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.connection.https.keystore;

import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import java.net.Socket;
import java.net.InetAddress;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.KeyManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.SecurityContext;

public class DynamicKeystoreSSLProtocolSocketFactory implements SecureProtocolSocketFactory {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.transportmessaging.connection.https.keystore");
    private SecurityContext mSecCtx = null;

    public DynamicKeystoreSSLProtocolSocketFactory(SecurityContext secCtx) {
        super();
        mSecCtx = secCtx;
    }

    public Socket createSocket(
        String host,
        int port,
        InetAddress clientHost,
        int clientPort)
        throws IOException, UnknownHostException {

        Socket socket = getSSLSocketFactory().createSocket(
            host,
            port,
            clientHost,
            clientPort
        );
        return socket;
    }

    public Socket createSocket(String host, int port)
        throws IOException, UnknownHostException {
        return getSSLSocketFactory().createSocket(
            host,
            port
        );
    }

    public Socket createSocket(
        Socket socket,
        String host,
        int port,
        boolean autoClose)
        throws IOException, UnknownHostException {
        return getSSLSocketFactory().createSocket(
            socket,
            host,
            port,
            autoClose
        );
    }

    private SSLSocketFactory getSSLSocketFactory() {
        SSLContext context = null;
        try {
            //want to initialise a trust manager and key manager that call the prevailing
            //security context for instructions.
            context = SSLContext.getInstance("SSL");
            context.init(
              new KeyManager[] {new SecurityContextX509KeyManager(mSecCtx)},
              new TrustManager[] {new SecurityContextX509TrustManager(mSecCtx)},
              null);
        } catch (Exception e) {
            mLogger.log(Level.SEVERE,e.getMessage(), e);
            throw new RuntimeException(e.toString());
        }
        return context.getSocketFactory();
    }
}
