/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.connection.https.keystore;

import javax.net.ssl.X509TrustManager;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.SecurityContext;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import java.util.logging.Level;
import uk.ac.soton.itinnovation.gemss.security.context.token.types.X509CertificateChainTokenImpl;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.MessageContextException;
import eu.gemss.components.security.token.types.pki.X509CertificateChainDescriptor;
import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.types.pki.X509CertificateChainToken;

public class SecurityContextX509TrustManager implements X509TrustManager {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.transportmessaging.connection.https.keystore.SecurityContextX509TrustManager");
    private SecurityContext mSecCtx = null;

    public SecurityContextX509TrustManager(SecurityContext secCtx) {
        mSecCtx = secCtx;
    }

    public void checkServerTrusted(X509Certificate[] chain,String authType) throws CertificateException {
        try {
          if(mSecCtx.isTrusted(new X509CertificateChainTokenImpl(chain,authType,false))) {
                mLogger.log(Level.FINE,"Have verified remote server as trusted given auth type '" + authType + "'");
          }
        }
        catch(MessageContextException ex) {
            throw new CertificateException(ex.getMessage());
        }
    }

    public void checkClientTrusted(X509Certificate[] chain,String authType) throws CertificateException {
        //this should not be called for client side invocation, could throw an exception but could simple check that
        //this client is trusted rather than blow up.
        try {
            if(mSecCtx.isTrusted(new X509CertificateChainTokenImpl(chain,authType,false))) {
                mLogger.log(Level.FINE,"Have verified local client as trusted given auth type '" + authType + "'");
            }
        }
        catch(MessageContextException ex) {
            throw new CertificateException(ex.getMessage());
        }

    }

    public X509Certificate[] getAcceptedIssuers() {
        //need the public key type and the principals offered by the server ??? Get them all???
        try{
            SecurityToken secToken = mSecCtx.generateSecurityToken(new X509CertificateChainDescriptor(true));
            X509CertificateChainToken certChain = (X509CertificateChainToken) secToken;
            return certChain.getX509CertificateChain();
        }
        catch(MessageContextException ex) {
            //method doesn't throw anything so log exception and return empty array
            mLogger.log(Level.SEVERE,"Unable to obtain accepted issuers, defaulting to none",ex);
            return new X509Certificate[0];
        }
    }
}