/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging;

import uk.ac.soton.itinnovation.gemss.transportmessaging.*;

public class InputArgumentException extends MessagingException {

    private static boolean FATAL_LEVEL = true;
    /**
     * Constructor takes the informative message to send to user
     * @param message message to send to user
     */
    public InputArgumentException(String message) {
        super(message,message,FATAL_LEVEL);
    }

    /**
     * Constructor takes distinct messages for the user and system
     * @param userMessage
     * @param systemMessage
     */
    public InputArgumentException(String userMessage, String systemMessage) {
        super(userMessage,systemMessage,FATAL_LEVEL);
    }

    /**
     * Constructor takes distinct messages for the user and system. It also allows
     * setting of whether the error that created this exception could be overcome if try again.
     * @param userMessage
     * @param systemMessage
     * @param fatal true if trying again won't help
     */
    public InputArgumentException(String userMessage, String systemMessage, boolean fatal) {
        super(userMessage,systemMessage,fatal);
    }

}
