/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging;

import java.io.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.*;

/**
 * Message is the basic message holder for the messaging framework
 */
public interface Message {

    /**
     * Retrieve the message context
     * @return Message context
     * @throws MessagingException
     */
    public MessageContext getMessageContext() throws MessagingException;

    /**
     * Set the message context
     * @param messageCtx message context
     * @throws MessagingException
     */
     public void setMessageContext(MessageContext messageCtx) throws MessagingException;

     /**
      * Write the contents of the message to the passed output stream, necessary
      * for sending message over the wire.
      * @param outStream output stream for message
      */
     public void writeTo(OutputStream outStream) throws MessagingException ;

     /**
      * Retrieves an input stream that can be used to read the contents of the message
      * @return input stream
      */
     public InputStream getInputStream() throws MessagingException;

     /**
      * Asks the message to release its internal data members, this is important
      * for very large messages.
      */
     public void release();


}