/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context;

import java.util.*;

/**
 * ConnectionProperties is a holder class for adding properties for a message
 */
public class ConnectionProperties {

    Map mProperties = null;

    /**
     * Default Constructor
     */
    public ConnectionProperties() {
        mProperties = new Hashtable();
    }

    public synchronized void addProperty(String name, String value) {
        if(name==null)
            throw new IllegalArgumentException("Invalid Connection property setting, name is null");
        if(value==null)
            throw new IllegalArgumentException("Invalid Connection property setting, value is null");

        mProperties.put(name,value);
    }

    public Map getProperties() {
        return mProperties;
    }
}