/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2003/09/19
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context;

import uk.ac.soton.itinnovation.gemss.transportmessaging.configuration.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.Iterator;

/**
 * MessageContext is a holder class for accessing context information for a message
 */
public class MessageContext {

    private TransportMessagingConfiguration mConfig;
    private SecurityContext mSecCtx;
    private ConnectionProperties mConnectionProperties = null;
    private Map msgProperties = null;

    /**
     * Default Constructor
     */
    public MessageContext(TransportMessagingConfiguration config) throws MessageContextException {
        try{
            mConfig = config;
            //load the correct provider of the security context
            String secProviderClassName = config.getSecurityContextProviderClassName();
            Class secProviderClass = Class.forName(secProviderClassName);
            mSecCtx = (uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.SecurityContext) secProviderClass.newInstance();
            mSecCtx.initialise(config);
        }
        catch(Exception ex) {
            //use the default class
            mSecCtx = new uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.DefaultSecurityContext();
            mSecCtx.initialise(config);

        }
        mConnectionProperties = new ConnectionProperties();
    }

    public MessageContext(TransportMessagingConfiguration config, SecurityContext secCtx) {
        mConfig = config;
        mSecCtx = secCtx;
        mConnectionProperties = new ConnectionProperties();
    }

    /**
     * Retrieve the security context for this message
     * @return security context
     */
    public SecurityContext getSecurityContext() {
        return mSecCtx;
    }

    /**
      * Retrieve the connection properties for the this message
      * @return connection properties
      */
     public ConnectionProperties getConnectionProperties() {
         return mConnectionProperties;
     }

     /**
      * Set the connection properties for this message
      * @param props connection properties.
      */
     public synchronized void setConnectionProperties(ConnectionProperties props) {
         mConnectionProperties = props;
     }

     /**
      * Set a message property
      * @param name
      * @param value
      */
     public synchronized void setMessageProperty(String name, Object value) {
       if(msgProperties==null) {
         msgProperties = new HashMap();
       }
       //check if there, if it is overwrite it
       Object obj = getMessageProperty(name);
       if(obj!=null)
         msgProperties.remove(obj);
       msgProperties.put(name,value);
     }

     /**
      * Retrieve a message property
      * @param name key for message property
      * @return property value or null if no value matches supplied key
      */
     public Object getMessageProperty(String name) {
       Set set = msgProperties.keySet();
       Iterator iterator = set.iterator();
       while(iterator.hasNext()) {
         String key = (String) iterator.next();
         if(key.equals(name)) {
           return msgProperties.get(key);
         }
       }
       return null;
     }

     /**
      * Retrieve the configuration that applies to this message
      * @return configuration
      */
     public TransportMessagingConfiguration getConfiguration() {
         return mConfig;
     }
}