/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context;

import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.*;

public class MessageContextException extends MessagingException {

    /**
     * Default constructor takes the informative message to send to user
     * @param message message to send to user
     */
    public MessageContextException(String message) {
        super(message);
    }

    /**
     * Constructor takes an informative message and a indicator for whether this
     * exception can be overcome by trying again
     * @param message
     * @param fatal
     */
    public MessageContextException(String message, boolean fatal) {
        super(message,message,fatal);
    }

    /**
     * Constructor takes distinct messages for users and system logs and an indication
     * of whether this exception can be overcome by trying again
     * @param userMessage
     * @param systemMessage
     * @param fatal
     */
    public MessageContextException(String userMessage, String systemMessage, boolean fatal) {
        super(userMessage,systemMessage,fatal);
    }

}
