/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context;

import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.*;

public class MessageSecurityContextException extends MessageContextException {

    private static boolean FATAL_LEVEL = true;
    private Exception mOriginalException = null;

    /**
     * Default constructor takes the informative message to send to user
     * @param message message to send to user
     */
    public MessageSecurityContextException(String message) {
        super(message,true);
    }

    /**
     * Constructor takes an informative message for the user and a boolean
     * to signal whether trying again is worthwhile
     * @param message
     * @param fatal
     */
    public MessageSecurityContextException(String message, boolean fatal) {
        super(message,message,fatal);
    }

    /**
     * Constructor takes distinct messages for the user and system logs and a boolean
     * to signal whether trying again is worthwhile
     * @param userMessage
     * @param systemMessage
     * @param originalException
     */
    public MessageSecurityContextException(String userMessage, String systemMessage,Exception originalException) {
        super(userMessage,systemMessage,FATAL_LEVEL);
    }

    /**
     * Constructor takes an information message for presentation to user and logging and
     * the original source exception that created this exception
     * @param message
     * @param originalException
     */
    public MessageSecurityContextException(String message, Exception originalException) {
        super(message,message,FATAL_LEVEL);
        mOriginalException = originalException;

    }

    /**
     * Retrieves the original exception that caused this one, in most cases this original
     * exception originates from the security library being used
     * @return original exception if exists, null otherwise
     */
    public Exception getOriginalException() {
        return mOriginalException;
    }

}
