/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2003/09/19
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context;

import eu.gemss.components.security.token.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.configuration.*;

/**
 * SecurityContext interface defines operations to access the security context
 * that exists for a message.
 */
public interface SecurityContext {

    /**
     * Set the configuration
     * @param config
     */
    public void initialise(TransportMessagingConfiguration config) throws MessageContextException;

    /**
     * Generate a security token of a particular type
     * @param type
     * @return security token
     */
    public SecurityToken generateSecurityToken(TokenDescriptor type) throws MessageContextException;

    /**
     * Test to see if the passed security token is trusted in the prevailing security context
     * @param token
     * @return
     * @throws MessageContextException
     */
    public boolean isTrusted(SecurityToken token) throws MessageContextException;

    /**
     * Add a security token instance to the prevailing security context
     * @param secToken security token to add
     * @throws MessageContextException
     */
    public void addSecurityTokenToContext(SecurityToken secToken) throws MessageContextException;

    /**
     * Remove from the prevailing security context the security token identified by the supplied token descriptor
     * @param secToken token to remove
     * @throws MessageContextException
     */
    public void removeSecurityTokenFromContext(SecurityToken secToken) throws MessageContextException;

    /**
     * Retrieve from the prevailing security context a previously stored security token matching the passed token descriptor
     * @param tokenDesc token identifier
     * @return security token required
     * @throws MessageContextException
     */
    public SecurityToken getSecurityTokenFromContext(TokenDescriptor tokenDesc) throws MessageContextException;
}