/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing;

import eu.gemss.components.transport.servicedescription.policytypes.*;
import eu.gemss.signals.SignalHandler;
import uk.ac.soton.itinnovation.gemss.transportmessaging.configuration.*;

public interface MessageProcessorProvider {

    /**
     * Retrieve a list of all the policy types supported by the provider
     * @return list of type descriptors
     */
    public PolicyTypeDescriptor[] getSupportedPolicyTypeList();

    /**
     * Retrieve an instance of the message processor described
     * by the type descriptor
     * @param typeDesc descriptor for required type of message processor
     * @return instance of the required message processor
     */
    public MessageProcessor getMessageProcessor(PolicyTypeDescriptor typeDesc) throws MessageProcessingException;

    /**
     * Sets the processor where provider signals should be sent
     * @param handler processing handler
     */
    public void setSignalHandler(SignalHandler handler);

    /**
     * Set the security token provider configuration
     * @param configuration
     */
    public void setMessagingProviderConfiguration(MessagingProviderConfiguration configuration);

}
