/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing.providers.wssecurity;

import eu.gemss.components.transport.servicedescription.policytypes.*;
import java.util.logging.*;
import eu.gemss.signals.SignalHandler;
import uk.ac.soton.itinnovation.gemss.transportmessaging.configuration.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing.providers.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.servicedescription.policytypes.*;

public class WSSecurityMessageProcessorProvider implements MessageProcessorProviderSpi {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.processing.providers.wssecurit.WSSecurityMessageProcessorProviderSpi");

    private PolicyTypeDescriptor[] mDescriptors = null;
    private SignalHandler mSignalHandler = null;
    private MessagingProviderConfiguration mConfiguration = null;

    /**
     * Retrieve a list of all the policy types supported by the provider
     * @return list of type descriptors
     */
    public PolicyTypeDescriptor[] getSupportedPolicyTypeList() {
        if(mDescriptors==null)
            init();
        return mDescriptors;
    }

    /**
     * Retrieve an instance of the message processor described
     * by the type descriptor
     * @param typeDesc descriptor for required type of message processor
     * @return instance of the required message processor
     */
    public MessageProcessor getMessageProcessor(PolicyTypeDescriptor typeDesc) throws MessageProcessingException {
        //check that support the typeDesc
        if(mDescriptors==null)
            init();
        for(int i=0;i<mDescriptors.length;i++) {
            if(typeDesc.isEqual(mDescriptors[i])){
                //create a suitable message processor
                return new WSSecurityMessageProcessor();
            }
        }
        mLogger.log(Level.SEVERE,"The selected WSSecurity message processor does not support policy descriptions described as '" + typeDesc.getDescription() + "'");
        throw new MessageProcessingException("The selected WSSecurity message processor does not support policy descriptions described as '" + typeDesc.getDescription() + "'");

    }

    /**
     * Sets the processor where provider signals should be sent
     * @param handler processing handler
     */
    public void setSignalHandler(SignalHandler handler) {
        mSignalHandler= handler;
    }

    /**
     * Set the security token provider configuration
     * @param configuration
     */
    public void setMessagingProviderConfiguration(MessagingProviderConfiguration configuration) {
        mConfiguration = configuration;
    }

    private void init() {
        PolicyTypeDescriptor desc = (new BodyX509SigCreateWSPolicyImp()).getPolicyTypeDescriptor();
        mDescriptors = new PolicyTypeDescriptor[2];
        mDescriptors[0] = desc;
        desc = (new BodyX509SigVerifyWSPolicyImp()).getPolicyTypeDescriptor();
        mDescriptors[1] = desc;
    }

}
