/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.payload;

import eu.gemss.components.transport.payload.*;
import java.io.*;
import java.util.logging.*;

/**
 * PayloadImpl class is holder class for input or output data for a service. It contains
 * zero or more DataItem instances.
 */
public class PayloadImpl extends Object implements Payload {

    private static Logger mLogger = Logger.getLogger("eu.gemss.components.transport.payload.Payload");

    private DataItem[] mDataItems;

    /**
     * Constructor creates an empty payload, only really useful for notification
     * type calls
     */
    public PayloadImpl() {
        mDataItems = new DataItem[0];
    }
    /**
     * Constructor enables passing of data items
     * @param dataItems array of data items, can be zero or more.
     */
    public PayloadImpl(DataItem[] dataItems) throws PayloadException {
        if(dataItems==null) {
            mLogger.log(Level.SEVERE,"Cannot create Payload with non-existent array of elements");
            throw new PayloadException("Cannot create Payload with non-existent array of elements");
        }
        //want to make sure that the data items have unique names
        for(int i=0;i<dataItems.length;i++) {
            String name = dataItems[i].getName();
            for(int j=i+1;j<dataItems.length;j++) {
                if(name.equals(dataItems[j].getName()))
                   throw new PayloadException("Payload invalid, it contains two data items with the same name");
            }
        }
        mDataItems = dataItems;
    }


    /**
     * Retrieves the data items that compose the payload
     * @return array of data items
     */
    public final DataItem[] getDataItems() {
        return mDataItems;
    }

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        //write the number of data items
        out.writeInt(mDataItems.length);

        //write each data item out
        for(int i=0;i<mDataItems.length;i++) {
            out.writeObject(mDataItems[i]);
        }
    }
    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        int numberOfDataItems = 0;
        //read the number of data items
        numberOfDataItems = in.readInt();

        mDataItems = new DataItem[numberOfDataItems];
        for(int i=0;i<numberOfDataItems;i++) {
            mDataItems[i] = (DataItem) in.readObject();
        }
    }
}
