/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2003/09/20
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.payload.serialisation;

import eu.gemss.components.transport.payload.*;
import java.util.*;
import org.w3c.dom.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.payload.serialisation.basicxsd.*;

public class TranslatorRegistry {

    private static TranslatorRegistry mRegistryInstance = null;
    private static List mTranslators = null;

    private TranslatorRegistry() {
        mTranslators = new ArrayList();
        addBasicTranslators();
    }

    public static TranslatorRegistry getInstance() {
        if(mRegistryInstance==null) {
            mRegistryInstance = new TranslatorRegistry();
        }
        return mRegistryInstance;
    }

    public synchronized void addDataItemDOMTranslator(DataItemDOMTranslator translator) {
        //could do with checking if it already exists, would require an addition method on a translator
        //for checking if two match.


        //check if it already exists
        Iterator iterator = mTranslators.iterator();
        boolean exists = false;
        while(iterator.hasNext()) {
            DataItemDOMTranslator crt = (DataItemDOMTranslator) iterator.next();
            if(crt.isSameTranslator(translator))
               exists = true;
        }
        if(!exists) {
            mTranslators.add(translator);
        }
    }

    /**
     * Retrieve a translator for the passed message element
     * @param node dom node
     * @return translator or null if a suitable one does not exist
     */
    public DataItemDOMTranslator getDataItemDOMTranslator(Node node) {
        DataItemDOMTranslator translator = null;
        try{
            Iterator iterator = mTranslators.iterator();
            while(iterator.hasNext()){
                DataItemDOMTranslator crt = (DataItemDOMTranslator) iterator.next();
                if(crt.canHandle(node)) {
                  translator = crt;
                }
            }
        }
        catch(PayloadException ex) {
            //simply allow null to be returned
        }
        return translator;
    }

    private void addBasicTranslators() {
        mTranslators.add(new SimpleXSDDataItemDOMTranslator());
    }
}