/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2002
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2003/09/16
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: Last commit info:    $Author: djm $ $Date:
//      2004/07/20 13:18:10 $ $Revision: 1.1.4.1 $
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.payload.typedescriptions;
import eu.gemss.components.transport.payload.*;
import java.io.*;
import javax.xml.namespace.*;
import org.apache.axis.*;

/**
 * SOAPEncTypeDescription handles types defined by SOAP 1.2 Datatype specification
 * (http://www.w3.org/TR/xmlschema-2/).
 */
public class SOAPENCTypeDescription implements TypeDescription {

    public static final QName SOAPENC_STRING = new QName(Constants.URI_DEFAULT_SOAP_ENC, "soapenc:string");
    public static final QName SOAPENC_BOOLEAN = new QName(Constants.URI_DEFAULT_SOAP_ENC, "soapenc:boolean");
    public static final QName SOAPENC_DOUBLE = new QName(Constants.URI_DEFAULT_SOAP_ENC, "soapenc:double");
    public static final QName SOAPENC_FLOAT = new QName(Constants.URI_DEFAULT_SOAP_ENC, "soapenc:float");
    public static final QName SOAPENC_INT = new QName(Constants.URI_DEFAULT_SOAP_ENC, "soapenc:int");
    public static final QName SOAPENC_INTEGER = new QName(Constants.URI_DEFAULT_SOAP_ENC, "soapenc:integer");
    public static final QName SOAPENC_BYTEARRAY = new QName(Constants.URI_DEFAULT_SOAP_ENC, "soapenc:base64Binary");

    private String mDescription;
    private QName mQName;
    private static final String mSerialisationLibrary = "MUST BE SET";

    /**
     * Only constructor requires that a short description be passed
     * @param shortDescription URI for XSD data type
     */
    public SOAPENCTypeDescription(String shortDescription,QName qName) {
        mDescription = shortDescription;
        mQName = qName;
    }

    /**
     * Checks to see if the passed type description matches this one
     * @param typeToCompare type to compare
     * @return true if match false otherwise
     */
    public boolean isEqual(TypeDescription typeToCompare){
        if(typeToCompare instanceof SOAPENCTypeDescription)
            return true;
        else
            return false;
    }

    /**
     * Retrieve the short description for this type, useful in logging and the like.
     * @return description
     */
    public final String getDescription() {
        return mDescription;
    }

    /**
     * Retrieve the qualified name for the this type, necessary as an identifier
     * when registering jaxrpc type mappings
     * @return
     */
    public QName getQName() {
        return mQName;
    }

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        //write out the xsd identifier
        out.writeObject(mDescription);
        //write out the QName
        out.writeObject(mQName.getNamespaceURI());
        out.writeObject(mQName.getLocalPart());
    }
    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        //read the xsd identifier
        mDescription = (String) in.readObject();
        //read in the QName
        mQName = new QName((String) in.readObject(),(String) in.readObject());
    }
}
