/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2003/10/19
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.proxies.axis;

import java.io.*;
import org.apache.axis.*;
import org.apache.axis.MessageContext;
import org.apache.axis.client.*;
import org.apache.axis.configuration.*;
import org.apache.axis.encoding.*;
import org.apache.axis.message.*;
import org.apache.axis.utils.*;
import org.apache.xml.security.c14n.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.configuration.*;
import uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.*;

/**
 * Provides functionality to generate a X509 Compliant SOAPEnveloper from a basic SOAPEnvelope
 */
public class AxisSecureSOAPEnvelope extends SOAPEnvelope {

    private String mTransportConfigDir;
    private String mSecurityConfigDir;
    private String mWSDLURI;
    private String mEndpoint;
    private String mPortType;
    private String mBinding;

    public AxisSecureSOAPEnvelope(String transportConfigDir, String securityConfigDir, String wsdlURI, String endpoint, String portType, String binding) throws TransportMessagingException {
        super();
        mTransportConfigDir = transportConfigDir;
        mSecurityConfigDir = securityConfigDir;
        mWSDLURI = wsdlURI;
        mEndpoint = endpoint;
        mPortType = portType;
        mBinding = binding;
    }


    public void encode(javax.xml.soap.SOAPMessage soapMessage, MessageContext msgContext, boolean isIncoming) throws  TransportMessagingException {
        try {

            //use web service enforcer
          //initialise the XML Security toolkit if it is not already so
            org.apache.xml.security.Init.init();
            WebServiceInvocationEnforcer wEnforcer = new WebServiceInvocationEnforcer(mTransportConfigDir,mSecurityConfigDir,mWSDLURI, mEndpoint, mPortType, mBinding);

            //note that you are creating a blank message context here that cannot be good but is OK
            //since the WebserviceInvocationEnforcer creates its own - fix this!!
            uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.MessageContext context =
                    new  uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.context.MessageContext(new TransportMessagingConfiguration(mTransportConfigDir));
            ConnectionProperties properties= context.getConnectionProperties();
            properties.addProperty("Content-Type","text/xml; charset=ISO-8859-1");
            properties.addProperty("SOAPAction","");

            uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.SOAPMessage soapMsg =
                    new uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.SOAPMessage(soapMessage, context);
            uk.ac.soton.itinnovation.gemss.transportmessaging.messaging.SOAPMessage secureMsg = null;
            if(isIncoming) {
                secureMsg =
                    wEnforcer.encodeRequest(soapMsg);
            }
            else {
                secureMsg =
                    wEnforcer.encodeResponse(soapMsg);
            }
            Document secureDoc = secureMsg.getDOMPart();

            Canonicalizer c14n = Canonicalizer.getInstance(Canonicalizer.ALGO_ID_C14N_WITH_COMMENTS);
            byte[] canonicalMessage = c14n.canonicalizeSubtree(secureDoc);


            InputSource is = new InputSource(new java.io.ByteArrayInputStream(canonicalMessage));
            DeserializationContextImpl dser = null;

            if (msgContext == null) {
                AxisClient tmpEngine = new AxisClient(new NullProvider());

                msgContext = new MessageContext(tmpEngine);
            }
            if(isIncoming) {
                dser = new DeserializationContextImpl(is, msgContext,
                    Message.REQUEST, this);
            }
            else {
                dser = new DeserializationContextImpl(is, msgContext,
                    Message.RESPONSE, this);
            }

            dser.parse();


        } catch (Exception e) {
            throw new TransportMessagingException(e.getMessage());
        }
    }

   
}
