/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.proxies.gemss;

import eu.gemss.components.providers.*;
import eu.gemss.components.transport.*;
import java.io.*;
import java.util.logging.*;

/**
 * IT Innovation provider for the standard gemss transport and messaging component
 */
public class GEMSSTransportMessagingProvider implements Provider {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.transportmessaging.proxies.gemss.GEMSSTransportMessagingProvider");
    private static final String TRANSPORT_MESSAGING_IDENTIFIER = "eu.gemss.components.transport.GEMSSTransportAndMessaging";
    private static final String COMPONENT_DESCRIPTION = "Transport and Messaging Component";
    private static final String TRANSPORT_MESSAGING_OWNER = "IT Innovation Centre";
    private static final boolean IS_LOCAL = true;
    private static final String VERSION = "0.1";
    private static GEMSSTransportAndMessaging mComponentInstance = null;


    /**
     * Default constructor takes no arguments so that it can be loaded easily
     * within the plug and play framework
     */
    public GEMSSTransportMessagingProvider() {
    }


    /**
     * Creates an instance of the TransportMessaginComponent
     * @return instance of security context component
     */
    public GEMSSTransportAndMessaging createTransportMessaging() throws eu.gemss.components.transport.GEMSSTransportAndMessagingException {
        try{
            //create a new GEMSSTransportMessagingComponent
            if( mComponentInstance == null )
                //create a new instance
                mComponentInstance = new GEMSSTransportMessagingImpl();
            return mComponentInstance;
        }
        catch(Exception ex) {
            mLogger.log(Level.SEVERE,"Unexpected failure occured inside transport messaging component provider (createTransportMessaging), please send a bug report including all log files",ex);
            throw new eu.gemss.components.transport.GEMSSTransportAndMessagingException("Unexpected failure occured inside transport messaging component, please send a bug report including all log files");
        }
    }

    public Object createComponent( eu.gemss.components.ServiceRequest serviceRequest ) throws IOException {
        try{
            //create a new GEMSSTransportMessagingComponent
            if(mComponentInstance == null)
                //create a new instance
                mComponentInstance = new GEMSSTransportMessagingImpl();
            return mComponentInstance;
        }
        catch(Exception ex) {
            mLogger.log(Level.SEVERE,"Unexpected failure occured inside transport messaging component provider (createComponent), please send a bug report including all log files",ex);
            throw new IOException("Unexpected failure occured inside transport messaging component, please send a bug report including all log files");
        }
    }

    public Object createComponent() throws IOException {
	  try{
		//create a new GEMSSTransportMessagingComponent
		if(mComponentInstance == null)
		    //create a new instance
		    mComponentInstance = new GEMSSTransportMessagingImpl();
		return mComponentInstance;
	  }
	  catch(Exception ex) {
		mLogger.log(Level.SEVERE,"Unexpected failure occured inside transport messaging component provider (createComponent), please send a bug report including all log files",ex);
		throw new IOException("Unexpected failure occured inside transport messaging component, please send a bug report including all log files");
	  }
    }

    public boolean supports(String identifier) {
        if(identifier.equals(TRANSPORT_MESSAGING_IDENTIFIER))
            return true;
        else
            return false;
    }

    public String getComponentName() {
        return TRANSPORT_MESSAGING_IDENTIFIER;

    }

    public String getProviderName() {
	  return TRANSPORT_MESSAGING_OWNER;

    }

    public String getDescription() {
        return COMPONENT_DESCRIPTION;
    }

    public boolean isLocal() {
        return IS_LOCAL;
    }

    public String getVersion() {
        return VERSION;
    }
}