/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.servicedescription;
import eu.gemss.components.transport.servicedescription.*;
import java.io.*;
import java.util.logging.*;

/**
 * ServiceDescription provides all information necessary to make a
 * service request.
 */
public class ServiceDescriptionImp implements ServiceDescription {

    private static Logger mLogger = Logger.getLogger("eu.gemss.components.transport.servicedescription.ServiceDescription");

    private ServiceInterface mInterfaceDesc;
    private ServiceEndpoint mEndpointDesc;
    private ServicePolicy mPolicyDesc;

    /**
     * Default constructor requires that this object be fully initialised
     * @param intfDesc service interface description
     * @param endPoint service endpoint description
     * @param policyDesc service policy description
     */
    public ServiceDescriptionImp(ServiceInterface intfDesc, ServiceEndpoint endPoint, ServicePolicy policyDesc) throws ServiceDescriptionException {
	    // check parameters
	    if(intfDesc==null || endPoint==null || policyDesc==null) {
		    mLogger.log(Level.SEVERE,"Service description is incomplete, one of serviceinterface, serviceprotocol or servicepolicy is not set");
		    throw new ServiceDescriptionException("Service description is incomplete, one of serviceinterface, serviceprotocol or servicepolicy is not set");
	    }

	    // note objects
	    mInterfaceDesc = intfDesc;
	    mEndpointDesc = endPoint;
	    mPolicyDesc = policyDesc;
    }

    /**
     * Retrieve the interface description for the required service
     * @return interface description
     */
    public ServiceInterface getServiceInterface(){
	    return mInterfaceDesc;
    }

    /**
     * Retrieve the endpoint description for the required service
     * @return endpoint description
     */
    public ServiceEndpoint getServiceEndpoint() {
	    return mEndpointDesc;
    }

    /**
     * Retrieve the service policy for the required service
     * @return policy description
     */
    public ServicePolicy getServicePolicy() {
	    return mPolicyDesc;
    }

    /**
     * read policy etc from file
     * @param Input stream where to read from
     */
    synchronized private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException
    {

	    // init (no constructor)
	    mLogger = Logger.getLogger("eu.gemss.components.transport.servicedescription.ServiceDescription");

	    try
	    {
		    // read the three data members from the stream
		    mInterfaceDesc = (ServiceInterface) in.readObject();
		    mEndpointDesc = (ServiceEndpoint) in.readObject();
		    mPolicyDesc = (ServicePolicy) in.readObject();

		    // all done
		    return;
	    }
	    catch ( Exception ex )
	    {
		    mLogger.log( Level.SEVERE,"Exception during readObject",ex);
		    throw new IOException("Failed to de-serialize serviceDesc object");
	    }
    }

    /**
     * write policy etc to file
     * @param Output stream where to write to
     */
    synchronized private void writeObject(java.io.ObjectOutputStream out) throws IOException
    {
	    try
	    {
		    // write the three data members to the stream
		    out.writeObject( mInterfaceDesc );
		    out.writeObject( mEndpointDesc );
		    out.writeObject( mPolicyDesc );

		    // all done
		    return;
	    }
	    catch ( Exception ex )
	    {
		    mLogger.log( Level.SEVERE,"Exception during writeObject",ex);
		    throw new IOException("Failed to serialize serviceDesc object");
	    }
    }

}
