/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2003/09/16
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.servicedescription.policytypes;

import eu.gemss.components.transport.servicedescription.policytypes.*;
import java.io.*;

/**
 * Policy implementation for situation where no policy is required
 */
public class NoPolicyImp implements Policy {

    public NoPolicyImp() {}

    public PolicyTypeDescriptor getPolicyTypeDescriptor() {
        return new NoPolicyImpTypeDescriptor();
    }

    public class NoPolicyImpTypeDescriptor implements eu.gemss.components.transport.servicedescription.policytypes.PolicyTypeDescriptor {

        private static final String DESCRIPTION_STRING = "No Policy";

       /**
        * Retrieve a short string description for the type
        * @return description
        */
       public String getDescription() {
           return DESCRIPTION_STRING;
       }

       /**
        * Check if this type matches the passed one
        * @param typeDesc identifier to check against
        * @return true if passed type is the same, false otherwise
        * @exception IllegalArgument If the passed type cannot be compared
        */
       public boolean isEqual(PolicyTypeDescriptor typeDesc) {
         if(typeDesc.getClass().getName().equals(this.getClass().getName())) {
           return true;
         }
         else {
               return false;
         }
        }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        //nothing to do
    }

     private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
         //nothing to do

     }
}
