/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.transportmessaging.servicedescription.policytypes;

import eu.gemss.components.transport.servicedescription.*;
import eu.gemss.components.transport.servicedescription.policytypes.*;
import java.io.*;
import java.util.*;

public class ServicePolicyImp implements ServicePolicy {

    private List mOutgoingPolicies;
    private List mIncomingPolicies;

    public ServicePolicyImp() {

    }

    /**
     * Add a policy item to the outgoing policies that apply to the service
     * @param policy policy item to add
     */
    public synchronized void addOutgoingPolicy(Policy policy) {
        if(mOutgoingPolicies==null)
            mOutgoingPolicies = new ArrayList();
        mOutgoingPolicies.add(policy);
    }

    /**
     * Add a policy item to the incoming policies that apply to the service
     * @param policy policy item to add
     */
    public synchronized void addIncomingPolicy(Policy policy) {
        if(mIncomingPolicies==null)
            mIncomingPolicies = new ArrayList();
        mIncomingPolicies.add(policy);
    }

    /**
     * Retrieve ordered list of policy item descriptors, order defines the order they
     * should be applied.
     * @return policy item descriptors
     */
    public PolicyTypeDescriptor[] getOrderedOutgoingPolicyTypes() {
        if(mOutgoingPolicies==null)
            return new PolicyTypeDescriptor[0];
        else {
            Iterator iterator = mOutgoingPolicies.iterator();
            PolicyTypeDescriptor[] descriptors = new PolicyTypeDescriptor[mOutgoingPolicies.size()];
            int index = 0;
            while(iterator.hasNext()) {
                descriptors[index++] = ((Policy) iterator.next()).getPolicyTypeDescriptor();
            }
            return descriptors;
        }
    }


    /**
     * Retrieve ordered list of policy item descriptors, order defines the order they
     * should be applied
     * @return
     */
    public PolicyTypeDescriptor[] getOrderedIncomingPolicyTypes() {
        if(mIncomingPolicies==null)
            return new PolicyTypeDescriptor[0];
        else {
            Iterator iterator = mIncomingPolicies.iterator();
            PolicyTypeDescriptor[] descriptors = new PolicyTypeDescriptor[mIncomingPolicies.size()];
            int index = 0;
            while(iterator.hasNext()) {
                descriptors[index++] = ((Policy) iterator.next()).getPolicyTypeDescriptor();
            }
            return descriptors;
        }
    }


    /**
     * Retrieve ordered list of policy items, order defines the order they should be
     * applied to an outgoing message
     * @return policy item list
     */
    public Policy[] getOrderedOutgoingPolicies() {
        if(mOutgoingPolicies==null)
            return new Policy[0];
        else {
            Iterator iterator = mOutgoingPolicies.iterator();
            Policy[] policies = new Policy[mOutgoingPolicies.size()];
            int index = 0;
            while(iterator.hasNext()) {
                policies[index++] = (Policy) iterator.next();
            }
            return policies;
        }
    }

    /**
     * Retrieve ordered list of policy items, order defines the order they should be applied
     * to an incoming message
     * @return
     */
    public Policy[] getOrderedIncomingPolicies() {
        if(mIncomingPolicies==null)
            return new Policy[0];
        else {
            Iterator iterator = mIncomingPolicies.iterator();
            Policy[] policies = new Policy[mIncomingPolicies.size()];
            int index = 0;
            while(iterator.hasNext()) {
                policies[index++] = (Policy) iterator.next();
            }
            return policies;
        }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {

        //write the number of outgoing policies
        out.writeInt(mOutgoingPolicies.size());
        //write the number of incoming policies
        out.writeInt(mIncomingPolicies.size());

        //write each outgoing policy
        Iterator iterator= mOutgoingPolicies.iterator();
        while(iterator.hasNext()) {
            Policy p = (Policy) iterator.next();
            out.writeObject(p);
        }

        //write each incoming policy
        iterator = mIncomingPolicies.iterator();
        while(iterator.hasNext()) {
            Policy p = (Policy) iterator.next();
            out.writeObject(p);
        }

    }

     private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
         //nothing to do
         int numberOutgoing = in.readInt();
         int numberIncoming = in.readInt();

         //read each outgoing policy
         mOutgoingPolicies = new ArrayList(numberOutgoing);
         for(int i=0;i<numberOutgoing;i++) {
             mOutgoingPolicies.add(in.readObject());
         }

         //read each incoming policy
         mIncomingPolicies = new ArrayList(numberIncoming);
         for(int i=0;i<numberIncoming;i++) {
             mIncomingPolicies.add(in.readObject());
         }
     }
}