/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: Freely distributed example code from builder.com
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////


// Obtained from builder.com, source published free with no licence
// exnetded by stuart to popup dialogue from a frame
package uk.ac.soton.itinnovation.gemss.utils.signalhandlers;

import java.awt.event.*;
import java.text.*;
import java.util.*;
import javax.swing.*;



/**
 * Custom button for entering dates. The <code>DateButton</code> class
 * is just a standard button that defines an additional bound
 * property: "date". The button displays the date property as its
 * label. When clicked, it does not generate an
 * <code>ActionEvent</code>, but displays a {@link DateChooser} dialog
 * instead, that allows you to change the date. When the date is
 * changed, a <code>PropertyChangeEvent</code> is generated, according
 * the contract for bound properties.
 **/
public class DateButton extends JButton
{
    /** Format to use to display the date property. */
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy");

    /** DateChooser instance to use to change the date. */
    private static DateChooser DATE_CHOOSER = null;

    /** Date property. */
    private Date date;



    /**
     * Called when the button is clicked, in order to fire an
     * <code>ActionEvent</code>. Displays the dialog to change the
     * date instead of generating the event and updates the date
     * property.
     *
     * @param e <code>ActionEvent</code> to fire
     **/
    protected void fireActionPerformed( ActionEvent e ) {
	Date newDate = DATE_CHOOSER.select(date);
	if ( newDate == null )
	    return;
	setDate( newDate );
    }



    /**
     * Constructs a new <code>DateButton</code> object with a given
     * date.
     *
     * @param date initial date
     * @param frame frame for date chooser dialogue box
     **/
    public DateButton( Date date, JFrame frame ) {
	super( DATE_FORMAT.format(date) );
	this.date = date;
      if( DATE_CHOOSER == null ) {
            DATE_CHOOSER = new DateChooser( frame,"Select Date" );
            DATE_CHOOSER.setLocationRelativeTo( frame ); // not right in top left!
      }
    }



    /**
     * Constructs a new <code>DateButton</code> object with the system
     * date as the initial date.
     * @param frame frame for date chooser dialogue box
     **/
    public DateButton( JFrame frame ) {
	this( new Date(),frame );
    }



    /**
     * Gets the value of the date property.
     *
     * @return the current value of the date property
     **/
    public Date getDate() {
	return date;
    }



    /**
     * Sets the valus of the date property.
     *
     * @param date new value of the date property
     *
     * @return the old value of the date property
     **/
    public void setDate( Date date ) {
	Date old = this.date;
	this.date = date;
	setText( DATE_FORMAT.format(date) );
	firePropertyChange( "date", old, date );
    }
}
