/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             P. Melas
//      Created date:           21-10-03
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.utils.zip;

import java.util.zip.*;
import java.io.*;

public class UnzipUtils{

    private static int BUFFER = 2048;

    /**
     * Uncompress a zip file to destination directory
     * @param name zipfile name
     * @param directory destination directory
     * @throws IOException
     */
    public static void uncompress(String name, String directory) throws IOException{
       ZipInputStream myIn = new ZipInputStream(new FileInputStream(name));
       BufferedOutputStream dest;
       ZipEntry entry;
       while((entry = myIn.getNextEntry()) != null) {
           //System.out.println("Extracting: " + entry);
           int count;
           byte data[] = new byte[BUFFER];
           mkdir(directory+File.separator+entry.getName());
           FileOutputStream fos = new FileOutputStream(directory+File.separator+entry.getName());
           dest = new BufferedOutputStream(fos, BUFFER);
           while ( (count = myIn.read(data, 0, BUFFER)) != -1)
               dest.write(data, 0, count);
           dest.flush();
           dest.close();
       }
    }

     private static void mkdir(String dirName) throws IOException{
	File dir;
	// dir.mkdir();
	int unix = dirName.lastIndexOf('/');
	int dos = dirName.lastIndexOf('\\');
	String path = dirName;

	if( unix > dos) {
	    path = dirName.substring(0, unix);
	    dir = new File(path);
	    dir.mkdirs();
	    return;
	}
	if( unix < dos){
	    path = dirName.substring(0, dos);
	    dir = new File(path);
	    dir.mkdirs();
	    return;
	}

	return;
    }



}
