/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.infrastructure;

import javax.swing.JFrame;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;

import java.awt.Font;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import java.util.Vector;

/*
* Swing JDialog that allows a choice of strings, or a new string to be entered
*/
public class SampleGUIChooser extends JDialog implements ActionListener, ListSelectionListener {

	// interface components
	private JTextField mtextFieldSelection;
	private JList mlistOptions;
      private JLabel mlabelSelection;
	private JButton mbuttonSelect;
	private JButton mbuttonAbort;

	// other
      private boolean mbAborted;
      private String mstrSelection;

	/*
	* Swing JDialogue that supports the choice of strings, or a new string to be entered
      * @param frame frame (null if no frame)
      * @param strTitle title of dialogue box
      * @param vectorOptions vector of strings to choose from
      * @param strSelect name for the select button (e.g. load, save)
	*/
	public SampleGUIChooser( JFrame frame, String strTitle, Vector vectorOptions, String strSelect )
	{
            // call constructor (model dialogue box)
            super( frame, strTitle, true );

            JPanel panel1, panel2, panel3;

		try {
                  // init
                  mstrSelection = null;
                  mbAborted = false;

			// make interface objects
                  getContentPane().setLayout( new BorderLayout( 5,5 ) );
                  getContentPane().add( new JLabel(),BorderLayout.WEST ); // make a left + right + top margin
                  getContentPane().add( new JLabel(),BorderLayout.EAST );
                  getContentPane().add( new JLabel(),BorderLayout.NORTH );
                  panel1 = new JPanel( new BorderLayout() );
                  getContentPane().add( panel1,BorderLayout.CENTER );

                  panel2 = new JPanel( new FlowLayout( FlowLayout.LEFT ) );
                  mlabelSelection = new JLabel( "Selection : " );
                  panel2.add( mlabelSelection );
			mtextFieldSelection = new JTextField( "<new entry>",40 );
                  panel2.add( mtextFieldSelection );

                  mlistOptions = new JList( vectorOptions );
                  mlistOptions.setPreferredSize( new Dimension( 100,100 ) );
                  mlistOptions.addListSelectionListener( this );
                  panel1.add( mlistOptions,BorderLayout.CENTER );
                  panel1.add( panel2,BorderLayout.SOUTH );

                  panel3 = new JPanel( new FlowLayout( FlowLayout.RIGHT ) );
                  getContentPane().add( panel3,BorderLayout.SOUTH );
                  mbuttonSelect = new JButton( strSelect );
                  mbuttonSelect.setActionCommand( "Select" );
                  mbuttonSelect.addActionListener( this );
                  panel3.add( mbuttonSelect );

                  mbuttonAbort = new JButton( "Abort" );
                  mbuttonAbort.setActionCommand( "Abort" );
                  mbuttonAbort.addActionListener( this );
                  panel3.add( mbuttonAbort );

                  setDefaultLookAndFeelDecorated( true );
                  setDefaultCloseOperation( JFrame.DISPOSE_ON_CLOSE );
		}
		catch( Exception ex ) {
			System.out.println("Failed to create sampleGUIChooser : "+ex.getMessage());
			ex.printStackTrace( System.out );
		}
	} // end constructor

	/*
	* Action listener for the buttons. Actions are Select, Abort
	* are handled presently.
	* @param e action event
	*/
	public void actionPerformed(ActionEvent e)
	{
		try {
			if( "Select".equals(e.getActionCommand()) ) {
                        mstrSelection = mtextFieldSelection.getText();
                        dispose();
			}
			else if( "Abort".equals(e.getActionCommand()) ) {
                        mbAborted = true;
                        dispose();
			}
		}
		catch( Exception ex ) {
			System.out.println("Action handler error : "+ex.getMessage());
		}
      }

      /*
      * List selection listener which will add selected strings to the edit control.
      * @param e action event
      */
      public void valueChanged(ListSelectionEvent e)
      {
            String strSelection;

            try {
                  strSelection = (String) mlistOptions.getSelectedValue();
                  if( strSelection != null ) {
                        // set new text
                        mtextFieldSelection.setText( strSelection );
                  }
            }
            catch( Exception ex ) {
                  System.out.println("Action handler error : "+ex.getMessage());
            }
      }

      /*
      * query abort status
      * @return true if the user has clicked the abort button
      */
      public boolean queryAborted()
      {
            return mbAborted;
      }
      /*
      * query selection (null if no selection made)
      * @return selected string, or null if no selection has been made
      */
      public String querySelection()
      {
            return mstrSelection;
      }

} // end SampleGUIChooser
